//  ****************************************************************
//  ****************************************************************
//	****														****
//	****	Interuptroutinen fr Magnetmesssystem				****
//	****														****
//  ****************************************************************
//  ****************************************************************

/*

Der CCS Compiler generiert Standartmsig eine Sicherungsorgie fr

 - FSR0 --> wird in Int_RDA und Int_TBE verwendet
 - FSR1
 - FSR2
 - PROD
 - BSR
 - Status
 - WREG
 - Adr0..Adr4 (Compiler Scratch Area fr Arithmetik)

Das wird durch #int_global umgangen
Verwendet werden nur FSR0 und ein Teil der Scratch Register, werden diese entfernt wrde dies noch
mal ca. 20 Instructions (10s) pro Interrupt sparen

!!! Bei verwendung einer anderen Compilerversion evtl. berprfung notwendig
*/

#int_global 

void Global_ISR(void)
{ int i,temp;
  int Temp_0,Temp_1,Temp_2,Temp_3,Temp_4;			// Sicherung fr Scratch Area
  int16 Temp_Fsr0;									// Sicherung fr FSR0
  #byte Scratch_0=0 
  #byte Scratch_1=1 
  #byte Scratch_2=2 
  #byte Scratch_3=3 
  #byte Scratch_4=4 

  // Register sichern
  // Status, Wreg und BSR werden automatisch gesichert
  Temp_0=Scratch_0;
  Temp_1=Scratch_1;
  Temp_2=Scratch_2;
  Temp_3=Scratch_3;
  Temp_4=Scratch_4;
  Temp_Fsr0=FSR0;

//  ****************************************************************
//	****									
//	****	TMR0-Int, wird zyklisch jede ms ausgelst
//	****									
//  ****************************************************************
	if (TMR0IE && TMR0IF)
	{ TMR0IF=0;
	  TMR0=TMR0StartValue;
	
	// Timeout fr RS232
	  if (_EmpfangAktiv)
	  { RS232_1Timeout++;								// Timeout erhhen, wenn Empfang aktiv
	    if (RS232_1Timeout>MaxRS232_1Timeout) 
	    { _EmpfangAktiv=false;				
		  _DatenEmpfangen=false;						// warscheinlich Strung, Daten verwerfen
	      PEbuff1=0;									// Zeiger auf Empfangspufferposition zurcksetzen
		}
	  }	
	  _TimeToRead5311=true;
	}	  

//  ****************************************************************
//	****							
//	****	RDA-Int, Zeichen ber UART empfangen
//	****				
//  ****************************************************************

	if (RCIE && RCIF)
	{ _EmpfangAktiv=true;
	  RS232_1Timeout=0;									// Timeout zurcksetzen
	  if (!FERR)
	  { temp=RCReg;
		i=temp;
		// Paritt berechnen
	    i ^= i >> 4;          // xor bit wise: 0=0^4, 1=1^5, 2=2^6, 3=3^7
	    i ^= i >> 2;          // xor bit wise: 0=0^2, 1=1^3
	    i ^= i >> 1;

	    if (RX9D==(i&1)) 
		{ Ebuff1[PEbuff1]=temp;							// empfangenes Byte in Empfangspuffer
	      if ((PEBuff1>0)&&(PEBuff1==Ebuff1[0]))		// alle Datenbytes empfangen?
	      { _EmpfangAktiv=false;						// Empfangsroutine beendet
		    _DatenEmpfangen=true;}						// Signalisierung, das Datensatz emfangen
	      else // alle Daten empfangen?
	      { PEBuff1++;									// Empfangspuffer auf nchstes Byte
	        if (PEBuff1>=EBuffSize1)
	         PEbuff1=0;// bei berlauf zurcksetzen
		  }
	    }
	  }
	  else // Framing Error
	  {i=RCREG;}										// Byte trotzdem lesen, aber nicht abspeichern
	}

//  ****************************************************************
//	****		
//	****	TBE-Int, Sendepuffer UART leer	
//	****		
//  ****************************************************************

	if (TXIE && TXIF)
	{ PSBuff1++;											// auf nchstes Byte
//	  GetParity(SBuff1[PSBuff1]);
	  i=SBuff1[PSBuff1];
        
// Paritt berechnen und als TX9D speichern
	  i ^= i >> 4;          // xor bit wise: 0=0^4, 1=1^5, 2=2^6, 3=3^7
	  i ^= i >> 2;          // xor bit wise: 0=0^2, 1=1^3
	  i ^= i >> 1;
	  TX9D=i&1;

	  TXREG=SBuff1[PSBuff1];								// nchstes Byte senden
	  if (PSBuff1>=ZSend1-1)								// alle Daten gesendet?
	  { Disable_Interrupts(Int_TBE);						// SendeInterrupt sperren
		PSBuff1=0;											// Zeiger auf Pufferanfang
	  }	
	}
  // Register rcksichern
  Scratch_0=Temp_0;
  Scratch_1=Temp_1;
  Scratch_2=Temp_2;
  Scratch_3=Temp_3;
  Scratch_4=Temp_4;
  FSR0=Temp_Fsr0;
#asm 
		retfie 1		// Diese Compilerversion muss verarscht werden um den Fast Register Stack auch
#endasm 				// bei Low Priority Interrupts zu verwenden	
		
}
